<?php
/**
 * Customizer info singleton class file.
 *
 * @package FlatX
 */

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Customizer_Info_Singleton {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ), 1);

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object $manager WordPress customizer object.
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		require_once( trailingslashit( get_template_directory() ) . 'inc/customizer-info/class/class-customizer-info-section.php' );

		// Register custom section types.
		$manager->register_section_type( 'Customizer_Info' );

		// Register sections.
		$manager->add_section( new Customizer_Info( $manager, 'flat_view_pro', array(
			'section_title' => __('Upgrade to pro', 'flat'),
			'section_url' => 'https://themeisle.com/plugins/flat-plus/',
			'section_text' => __('Get it', 'flat'),
			'priority' => 900,
		) ) );

		// Register sections.
		$manager->add_section( new Customizer_Info( $manager, 'flat_pro_color', array(
			'section_text' => __( 'Check out the <a href="http://themeisle.com/plugins/flat-plus/">PRO version</a> for some awesome color schemes!', 'flat' ),
			'panel' => 'panel_design',
			'priority' => 500,
		) ) );

		// Register sections.
		$manager->add_section( new Customizer_Info( $manager, 'flat_pro_woo', array(
			'section_text' => __( 'Check out the <a href="http://themeisle.com/plugins/flat-plus/">PRO version</a> for full compatibility with WooCommerce!', 'flat' ),
			'panel' => 'panel_design',
			'priority' => 501,
		) ) );

		// Register sections.
		$manager->add_section( new Customizer_Info( $manager, 'flat_pro_scroll', array(
			'section_text' => __( 'Check out the <a href="http://themeisle.com/plugins/flat-plus/">PRO version</a> for full compatibility with Jetpack Infinite Scroll option!', 'flat' ),
			'panel' => 'panel_design',
			'priority' => 500,
		) ) );
	}

	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'customizer-info-js', trailingslashit( get_template_directory_uri() ) . 'inc/customizer-info/js/customizer-info-controls.js', array( 'customize-controls' ) );

	}
}

Customizer_Info_Singleton::get_instance();
