<?php
/**
 * @version   4.0.8 October 3, 2013
 * @author Webempresa http://www.webempresa.com
 * @copyright Copyright (C) 2013 Webempresa
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 *
 */
defined( 'GANTRY_VERSION' ) or die();

gantry_import( 'core.gantrylayout' );

/**
 *
 * @package gantry
 * @subpackage html.layouts
 */
class GantryLayoutChrome_Basic extends GantryLayout {
	var $render_params = array(
		'gridCount'     =>  null,
		'prefixCount'   =>  0,
		'extraClass'      =>  ''
	);

	function render($params = array()){
		global $gantry, $wp_registered_widgets;    
		$rparams = $this-> _getParams($params[0]);
		$instance_params = $this->_getWidgetInstanceParams($params[0]['widget_id']);
		
		$id =  $params[0]['widget_id'];
		$classname = $wp_registered_widgets[$params[0]['widget_id']]['classname'];

		$params[0]['pre_widget'] = '';
		$params[0]['widget_open'] = '';
		$params[0]['title_open'] = '';
		$params[0]['title_close'] = '';
		$params[0]['widget_close'] = '';
		$params[0]['post_widget'] = '';
		$params[0]['pre_render'] = '';
		$params[0]['post_render'] = '';
		
		$widget_variations = $pre_widget = $post_widget = $widget_open = $widget_close = $title_open = $title_close = $pre_render = $post_render = '';

		$variations = array( 'custom-variations', 'box-variations', 'title-variations' );

		foreach ( $variations as $variation ) {
			if ( array_key_exists( $variation, $instance_params ) && $instance_params[$variation] != false ) {
				if ( $instance_params[$variation] != '' ) $widget_variations .= ' ' . $instance_params[$variation];
			}
		}

		$widget_variations = trim( $widget_variations );
		( $widget_variations != '' ) ? $widget_variations = ' ' . $widget_variations : $widget_variations = '';

		?>

		<?php /** Begin Chrome Layout **/ ?>

		<?php ob_start(); ?>
		<div id="<?php echo $id; ?>" class="widget <?php echo $classname . $widget_variations; ?>">
		<?php $widget_open = ob_get_clean(); ?>
		<?php ob_start(); ?>	
		</div>
		<?php $widget_close = ob_get_clean(); ?>

		<?php /** End Chrome Layout **/ ?>

		<?php
		
		$params[0]['widget_open'] = $widget_open;
		$params[0]['widget_close'] = $widget_close;

		if( !empty( $instance_params['title'] ) ) {
			$params[0]['before_widget'] = $params[0]['pre_widget'] . $params[0]['widget_open'];
			$params[0]['before_title'] = $params[0]['title_open'];
			$params[0]['after_title'] =  $params[0]['title_close'] . $params[0]['pre_render'];
			$params[0]['after_widget'] = $params[0]['post_render'] . $params[0]['widget_close'] . $params[0]['post_widget'];
		} else {
			$params[0]['before_widget'] = $params[0]['pre_widget'] . $params[0]['widget_open'] . $params[0]['pre_render'];
			$params[0]['before_title'] = $params[0]['title_open'];
			$params[0]['after_title'] =  $params[0]['title_close'];
			$params[0]['after_widget'] = $params[0]['post_render'] . $params[0]['widget_close'] . $params[0]['post_widget'];
		}
		
		return $params;
	}
}